% Paint.CAT について

---

## これは何か？

古き良き時代のペイントのようなものを目指して作ったもの．  
動作には .NET 9.0 が必要です（ランタイムのインストールが必要かもしれません）．

### 何でどう作ったのか

Windows11上で Visual Studio 2022 で作りましたが，
別の環境で 動く/動かない とか，そういう点が正確にわからないので情報を記しておきます．  

* Visual Studio 2022 を使用
	* C# の "Windows Forms" という種類のプロジェクトで作成．
	* .NET Framework 9.0 を使用．

---

## 捨てる方法

* 本体の捨て方：  
  現在，インストーラとかは無い状態なので丸ごとファイル削除してください．  
  レジストリとかは使っていない（ハズ/つもり）です．
* 設定ファイルの捨て方：  
  APP終了時に設定ファイルがユーザフォルダ下の  
  `AppData/Local/NyancoRitter`  
  というフォルダ内に保存されます．  
  大した容量ではありませんが，気になる場合にはこちらも手動で削除してください．  
  （`NyancoRitter` フォルダを丸ごと削除すればOKです）

---

## 利用規約

* 本アプリケーションおよびその不随物（：現状ではこのReadMeだけが該当）の再配布に関しては  
  **【再配布行為および再配布物によって生じた事柄の一切の責任を再配布者が負う】という条件の下でのみ許可します**．  
* 本アプリケーションの商用利用は禁じます．

---

## 免責

本アプリケーションの不具合，本アプリケーションおよびその不随物を使用すること（もしくは使用できなかったこと）に関して
発生した 損害/厄介事 について，本アプリケーションの制作者は一切責任を負わないものとします．  
完全に自己責任でご利用ください．

---

## 更新履歴

* 2025/12/27 (Ver 2.0.0 Beta)
	* .NET 9.0 に移行
	* 高DPI対応方法を変更
	* 以下の怪しい挙動に対処した（つもり）  
		* Paste 時に，ごく稀にその周辺が変な色に変わってしまう現象
		* Transparent にチェックが入っている場合に Rotate/Flip が正しく機能しない問題
		* Free-Form 範囲選択ツールで広さ2画素の選択をすると例外が発生する問題

### 旧バージョンの履歴

.Net Framework 4.8 を使用していたバージョンの履歴：

* 2025/8/22 (Ver 1.09)
	* モノクロBMPエクスポート機能を追加
* 2025/6/2 (Ver 1.08)
	* キー操作で範囲選択ツールに切り替わった際に，ツール選択タブの表記が更新されないバグを修正
* 2025/5/19 (Ver 1.07)
	* 画像表示域がスクロールしている際にはPaste初期位置を現在見えている範囲の左上とする
* 2025/5/17 (Ver 1.06)
	* 画像読込時にbit深度を24bit化する措置を追加  
	  （画像読込を行うと32bitになっていた）
* 2025/4/26 (Ver 1.05)
	* 矩形選択範囲をドラッグした際に消去される範囲が選択範囲と異なるバグを修正
	* 矩形選択範囲のサイズをキー操作で変えた際にステータスバーのサイズ表示が更新されないバグを修正
* 2025/3/29 (Ver 1.04)
	* Eraserの初期描画範囲表示が実際と異なるバグを修正
	* Penツールが2x2モードの際にCtrlでのスポイト機能が使えない問題を修正
	* 左右ボタンの色を直接編集する機能を追加
	* スポイト機能周りの表示不具合を改善
* 2025/3/23 (Ver 1.03)
	* "Paste To" 機能の追加．  
	* Penツールに2x2モードを追加．  
	* 範囲選択状態からEraserツールに切り替えた際にEraserの範囲が表示されない問題に対処．
	* FreeForm選択時の選択範囲表示（仮）
	* コマンドライン引数に指定された画像を開く機能を追加
* 2025/3/11 (Ver 1.02)
	* FreeFormの選択範囲が大きい場合に圧倒的に処理時間がかかる問題を修正
* 2025/3/6 (Ver 1.01)
	* 編集中にキー操作すると例外が出たりする問題を修正
* 2025/3/5 (Ver 1.00)
	* 初版

---

By NyancoRitter
